/*
	Programa servidor de ECO
	Configuracin del puerto serie: 9600, 8, N, 1
	Cuando se recibe un caracter se cambia el estado del LED RB0
*/


#include <p18f452.h>
#include <usart.h>


void main(void) {
	unsigned char car;

	TRISB=0;   // puerto B configurado de salida
	PORTB=0;

	// Configuramos el puerto serie
	OpenUSART( USART_TX_INT_OFF  &
			   USART_RX_INT_OFF  &
 			   USART_ASYNCH_MODE &
               USART_EIGHT_BIT   &
               USART_CONT_RX     &
               USART_BRGH_HIGH,
               25 );	

	// programa principal
	while (1) {
		while ( !DataRdyUSART() ); // Espera a que haya un dato listo
		car = getcUSART();           // Lee el caracter nuevo
		PORTB ^= 0x01;             // Cambia el estado del LED
		WriteUSART(car);           // Manda el caracter recibido
	}
}


	
